package clmedit;

import javax.swing.*;
import java.io.*;
import java.awt.*;

public class CalominEditor2 {
    
    /*The caves*/
    static short[][][] caveData = new short[14][20][22];
    static byte currentCave;
    static DrawPanel drawPanel;
    static EditorFrame eFrame;
    static byte loaded=0;
    static JFileChooser jfcLoad;
    static JFileChooser jfcSave;
    static byte[] fileData;
    static int fileSkip;
    static int caveCount;
    
    
    /** Creates a new instance of CalominEditor */
    public CalominEditor2() {
    }
    
    public static void main(String[] args)  {
        
        fileSkip=684;
        caveCount=14;
        
        if (args.length==2) {
            try {
                fileSkip=Integer.parseInt(args[0]);
                
            }
            catch(Exception e) {
                JOptionPane.showMessageDialog(null,"First parameter is not a number");
                return;
            }
            try {
                caveCount=Integer.parseInt(args[1]);
            }
            catch(Exception e) {
                JOptionPane.showMessageDialog(null,"Second parameter is not a number");
                return;
            }
            
            if (fileSkip<0 || caveCount <0) {
                JOptionPane.showMessageDialog(null,"At least one parameter is negative");
                return;
            }
        }
        
        
        
        jfcLoad = new JFileChooser();
        jfcSave = new JFileChooser();
        jfcSave.setDialogType(JFileChooser.SAVE_DIALOG);
        eFrame=new EditorFrame();
        drawPanel=new DrawPanel();
        drawPanel.initImages();
        eFrame.jscCavePane.setOpaque(false);
        eFrame.jscCavePane.setBackground(java.awt.Color.black);
	JPanel pnl = new JPanel(new FlowLayout());
	pnl.setBackground(Color.blue);
        eFrame.jscCavePane.setViewportView(pnl);
	pnl.add("Center",drawPanel);
        eFrame.setVisible(true);
        
    }
    
    public static void quitEditor() {
        System.exit(0);
    }
    
    /*Load cave*/
    public static int load(String s) {
        try {
            RandomAccessFile raf = new RandomAccessFile(s,"r");
            
            if (raf.length()>65536) {
                raf.close();
                return -1;
            }
            
            fileData = new byte[(int)raf.length()];
            raf.readFully(fileData);
            
            raf.seek(fileSkip);
            for (int c=0;c<caveCount;c++) {
                for (int x=0;x<20;x++) {
                    for (int y=0;y<22;y++) {
                        caveData[c][x][y]=(short)((raf.read())-1);
                    }
                }
            }
            raf.close();
            
        }
        catch (Exception e) {
            loaded=0;
            e.printStackTrace();
            return -1;
            
        }
        loaded=1;
        return 0;
    }
    
    
    public static int save(String s) {
        try {
            RandomAccessFile raf = new RandomAccessFile(s,"rw");
            raf.write(fileData);
            
            raf.seek(fileSkip);
            for (int c=0;c<caveCount;c++) {
                for (int x=0;x<20;x++) {
                    for (int y=0;y<22;y++) {
                        raf.write(caveData[c][x][y]+1);
                    }
                }
            }
            raf.close();
            
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        
        return 0;
    }
    
}
